#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//CubicMod01.fsh   by  Xor  
//https://www.shadertoy.com/view/Ddt3z2
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
    Experimenting with raymarching AO tonight

*/
#define EPS .001
#define MAX 300.

mat2 rotate(float r)
{
    return mat2(cos(r),-sin(r),sin(r),cos(r));
}
float dist(vec3 p)
{
    float d = 1e4;
    
    for(float i  = 1.0;i<4.0;i++)
    {
        float r = exp(i*0.5);
        p.xz *= mat2(-.6,-.8,.8,-.6);
        p.zy *= mat2(.6,-.8,.8,.6);
        vec3 m = mod(p+iTime*vec3(.1,0,0),r*2.)-r;
        d = min(d,length(max(abs(m)-r*.3,0.0)));
    }
    return d;
}
vec3 normal(vec3 p)
{
    vec2 e = vec2(2,-2)*EPS;
    return normalize(dist(p+e.xxy)*e.xxy+dist(p+e.xyx)*e.xyx+
    dist(p+e.yxx)*e.yxx+dist(p+e.y)*e.y);
}
float ao(vec3 p, vec3 n)
{
    float w = 0.0;
    float s = 1.0;
    for(float d = EPS*40.; d<2.; d*=2.)
    {
        s *= clamp(dist(p+n*d)/d*0.5+0.5, 0.0, 1.0);
        w++;
    }
    
    return pow(s,2.0/w);
}
vec3 color(vec3 p)
{
    vec3 n = normal(p);
    return vec3(ao(p,n));
}
vec4 march(vec3 p,vec3 r)
{
    vec4 m = vec4(p+r,1);
    for(int i = 0;i<200;i++)
    {
        float s = dist(m.xyz);
        m += vec4(r,1)*s;
        
        if (m.w>MAX) return m;
    }
    return m;
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 r = normalize(vec3(fragCoord-.5*iResolution.xy,iResolution.y));
    r.yz *= rotate(0.3);
    r.xz *= rotate(iTime*0.1);
    
    vec4 m = march(vec3(0,0,0),r);
    vec3 c = color(m.xyz);
    c *= smoothstep(MAX,0.,m.w);
    
    fragColor = vec4(c,1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

